<?php 
session_start();

require("config/conn.php");
require("functions.php");
include("includes/header.php");
include("includes/topbar.php");
include("includes/sidebar.php");

session_regenerate_id(true);

if (!isset($_SESSION['AdminLoginId'])) {
    header("Location: index.php");
} 

?>



<main>
    <div class="container-fluid px-4">

        <h1 class="mt-4 dash-heading">Settings</h1>
        <ol class="breadcrumb mb-4">
            <li class="breadcrumb-item active">Settings</li>
        </ol>



        <div class="row my-4">
            <div class="col-12 add-category-box my-4">
                <h1 class="category-heading">Basic Settings</h1>
                <div class="categort-add-container">
                    <form  action="code.php" method="POST">
                        <div class="d-flex align-items-center flex-wrap">
                        <div class="mb-3 mx-2">
                            <label for="homequizcount" class="form-label">Home Quiz Count</label>
                            <input type="number" value="<?= getSettingValue('basicsettings', 'Home Quiz Count') ?>" class="form-control" id="homequizcount" name="homequizcount">
                        </div>
                        <div class="mb-3 mx-2">
                            <label for="dailyCheckinPrize" class="form-label">Daily Check In Prize</label>
                            <input type="number" value="<?= getSettingValue('basicsettings', 'Daily Check In Prize') ?>" class="form-control" id="dailyCheckinPrize" name="dailyCheckinPrize">
                        </div>
                        <div class="mb-3 mx-2">
                            <label for="minWithdrawLimit" class="form-label">Minimum Withdraw Limit</label>
                            <input type="number" value="<?= getSettingValue('basicsettings', 'Minimum Withdraw Limit') ?>" class="form-control"  id="minWithdrawLimit" name="minWithdrawLimit">
                        </div>
                        <div class="mb-3 mx-2">
                            <label for="maxWithdrawLimit" class="form-label">Maximum Withdraw Time</label>
                            <input type="number" value="<?= getSettingValue('basicsettings', 'Maximum Withdraw Time') ?>" class="form-control" id="maxWithdrawLimit" name="maxWithdrawLimit">
                        </div>
                        <div class="mb-3 mx-2">
                            <label for="conversionRate" class="form-label">Conversion Rate</label>
                            <input type="number" value="<?= getSettingValue('basicsettings', 'Conversion Rate') ?>" class="form-control" id="conversionRate" name="conversionRate">
                        </div>
                        <div class="mb-3 mx-2">
                            <label for="baseURL" class="form-label">Base URL</label>
                            <input type="text" value="<?= getSettingValue('basicsettings', 'Base URL') ?>" class="form-control" id="baseURL" name="baseURL">
                        </div>
                        <div class="mb-3 mx-2">
                            <label for="conversionRate" class="form-label">Firebase Key</label>
                            <textarea type="text"class="form-control" id="firebaseKey" name="firebaseKey" rows="5" cols="100"><?= getSettingValue('basicsettings', 'Firebase Key') ?></textarea>
                        </div>
                        
</div>
                        <button type="submit"  name="save_basic_settings" class="add-category-btn  mb-3 mx-2">Save</button>
                    </form>
                </div>

            </div>
           
            <div class="col-12 add-category-box  my-4">
                <h1 class="category-heading">Reward Settings</h1>
                <div class="categort-add-container">
                    <form class="d-flex align-items-center flex-wrap" action="code.php" method="POST">
                        <div class="mb-3 mx-2">
                            <label for="watchAdCoinReward" class="form-label">Watch Ad Coin Reward</label>
                            <input type="number" value="<?= getSettingValue('rewardsettings', 'Watch Ad Coin Reward') ?>" class="form-control" id="watchAdCoinReward" name="watchAdCoinReward">
                        </div>
                        <div class="mb-3 mx-2">
                            <label for="inviteSenderReward" class="form-label">Invite Sender Reward</label>
                            <input type="number" value="<?= getSettingValue('rewardsettings', 'Invite Sender Reward') ?>" class="form-control" id="inviteSenderReward" name="inviteSenderReward">
                        </div>
                        <div class="mb-3 mx-2">
                            <label for="inviteeReward" class="form-label">Invitee Reward</label>
                            <input type="number" value="<?= getSettingValue('rewardsettings', 'Invitee Reward') ?>" class="form-control" id="inviteeReward" name="inviteeReward">
                        </div>
                        <button type="submit" class="add-category-btn edit-category-btn mt-3" name="save_reward_settings">Save</button>
                    </form>
                </div>

            </div>
            <div class="col-12 add-category-box  my-4">
                <h1 class="category-heading">AD Settings</h1>
                <div class="form-check form-switch mx-4">
                        <?php
                        
                        $sql = "SELECT * FROM `basicsettings` WHERE `name`='adEnabled'";

                        $query_run = mysqli_query($conn, $sql);

                        if ($query_run):
                            foreach ($query_run as $row):
                                if ($row['value'] == 1) {
                                    $check = 'checked';
                                    
                                } else{
                                    $check = '';
                                }
?>  

                    <input class="form-check-input enableSwitch" style="height: 2rem;
width: 4rem;" type="checkbox" role="switch" value="<?= $row['value']; ?>"  id="<?= $row['id']; ?>" <?= $check; ?>>

<?php

                            endforeach;
                        
                        else:

                        endif;
                        
                        ?>
                       
                    </div>
                    <br>
<p id="text" class="mx-4"></p>
                <div class="categort-add-container" id=" AD-Setting-container">
                   

                            <form action="code.php" method="POST" id="form">
                            <div class="d-flex align-items-center flex-wrap">
                        <div class="mb-3 mx-2 col-4">
                            <label for="nativeBannerID" class="form-label">Native Banner Ad</label>
                            <input type="text" value="<?= getSettingADValue('adsettings', 'Native Banner Ad') ?>" class="form-control" id="nativeBannerID" name="nativeBannerID">
                        </div>
                        <div class="mb-3 mx-2 col-4">
                            <label for="interstitialAd" class="form-label">Interstitial Ad</label>
                            <input type="text" value="<?= getSettingADValue('adsettings', 'Interstitial Ad') ?>" class="form-control" id="interstitialAd" name="interstitialAd">
                        </div>
                        <div class="mb-3 mx-2 col-4">
                            <label for="rewardAdId" class="form-label">Rewarded Ad</label>
                            <input type="text" value="<?= getSettingADValue('adsettings', 'Rewarded Ad') ?>" class="form-control" id="rewardAdId" name="rewardAdId">
                        </div>
                        </div>
                        <button type="submit" class="add-category-btn edit-category-btn my-3" name="save_ad_settings">Save</button>
                    </form>
                    
                </div>

            </div>
        </div>





    </div>




</main>









<?php 

include("includes/script.php");

?>


<script>
    <?php

    if (isset($_SESSION['status'])) {
    ?>
            swal("<?= $_SESSION['message']; ?>", {
                icon: "<?= $_SESSION['icon'] ?>",

            }
            );
    <?php
  unset($_SESSION['status']);
        unset($_SESSION['message']);
        unset($_SESSION['icon']);
    }

?>


</script>
<script>

        let enableSwitch = $('.enableSwitch').val();
        if (enableSwitch == 1) {
            $("#form").css('display', 'block');
            $('#text').html('');
        } else{
            $("#form").css('display', 'none');
            $('#text').html('AD are Disabled');
        }
   
   


    $('.enableSwitch').on('click', function () {

        $.ajax({
            type: "POST",
            url: "code.php",
            data: {
                'check_onOff': true
            },
            success: function (response) {
                
                let id = $(this).attr('id');
                $.each(response, function (key, value) { 
                     var check =  value['value'];
                    //  console.log(check);
                

       
        if (check == '1') {
            // console.log('disabled');

            $.ajax({
                type: "POST",
                url: "code.php",
                data: {
                    'disable_ad': true
                },
                success: function (response) {
                    $("#form").css('display', 'none');
                    $('#text').html('AD are Disabled');
                    // $("form").hide();
                    swal({
                        title: "AD Disabled",
                        text: "AD Disabled Successfully",
                        icon: "success",
                    });

                   
                }
            });

        } else{
            $.ajax({
                type: "POST",
                url: "code.php",
                data: {
                    'enable_ad': true,
                },
                success: function (response) {
                    // $("form").show();
                    $("#form").css('display', 'block');


                    $('#text').html('');
                    swal({
                        title: "AD Enabled",
                        text: "AD Enabled Successfully",
                        icon: "success",
                    });
                    

                }
            });
        }

    });
            }
        });


     
    });
</script>




<?php

include("includes/footer.php");


?>